var NAVTREE =
[
  [ "AnyConnect Secure Mobility Client", "index.html", [
    [ "AnyConnect VPN Client C++ API", "index.html", null ],
    [ "Related Pages", "pages.html", [
      [ "Building an AnyConnect client", "build_sec.html", null ],
      [ "Basic Capabilities", "basic_cap_pag.html", null ],
      [ "The API Interface", "api_files_sec.html", [
        [ "Event Models", "evt_sub.html", null ],
        [ "Required Implementation", "req_sub.html", null ],
        [ "General API Methods", "bas_sub.html", [
          [ "Client State Checking", "client_state_sub.html", null ],
          [ "VPN Status Checking", "vpn_state_sub.html", null ],
          [ "Externally Initiated Exit Requests", "external_exit_sub.html", null ],
          [ "Using Secure Gateway Hosts", "sg_hosts_sub.html", null ],
          [ "Managing VPN Connections", "manage_vpns_sub.html", null ],
          [ "Managing Flow of Statistics", "stats_manage_sub.html", null ]
        ] ]
      ] ],
      [ "Advanced Topics", "adv_page.html", null ]
    ] ],
    [ "Class List", "annotated.html", [
      [ "CDialog", "class_c_dialog.html", null ],
      [ "CLIClientImpl", "class_c_l_i_client_impl.html", null ],
      [ "ClientIfc", "class_client_ifc.html", null ],
      [ "ClientIfcBase", "class_client_ifc_base.html", null ],
      [ "ConnectPromptInfo", "class_connect_prompt_info.html", null ],
      [ "ConnectPromptInfoBase", "class_connect_prompt_info_base.html", null ],
      [ "CWinApp", "class_c_win_app.html", null ],
      [ "FirewallInfo", "class_firewall_info.html", null ],
      [ "PromptEntryBase::GroupAttributes", "class_prompt_entry_base_1_1_group_attributes.html", null ],
      [ "Gui", "class_gui.html", null ],
      [ "GUIClientImpl", "class_g_u_i_client_impl.html", null ],
      [ "MainDialog", "class_main_dialog.html", null ],
      [ "Preference", "class_preference.html", null ],
      [ "PreferenceBase", "class_preference_base.html", null ],
      [ "PreferenceInfo", "class_preference_info.html", null ],
      [ "PreferenceInfoBase", "class_preference_info_base.html", null ],
      [ "PromptDialog", "class_prompt_dialog.html", null ],
      [ "PromptEntry", "class_prompt_entry.html", null ],
      [ "PromptEntryBase", "class_prompt_entry_base.html", null ],
      [ "ProtocolInfo", "class_protocol_info.html", null ],
      [ "RouteInfo", "class_route_info.html", null ],
      [ "PromptEntryBase::SingleAttributes", "class_prompt_entry_base_1_1_single_attributes.html", null ],
      [ "VPNStats", "class_v_p_n_stats.html", null ],
      [ "VPNStatsBase", "class_v_p_n_stats_base.html", null ]
    ] ],
    [ "Class Index", "classes.html", null ],
    [ "Class Hierarchy", "hierarchy.html", [
      [ "CDialog", "class_c_dialog.html", [
        [ "MainDialog", "class_main_dialog.html", null ],
        [ "PromptDialog", "class_prompt_dialog.html", null ]
      ] ],
      [ "ClientIfcBase", "class_client_ifc_base.html", [
        [ "ClientIfc", "class_client_ifc.html", [
          [ "CLIClientImpl", "class_c_l_i_client_impl.html", null ],
          [ "GUIClientImpl", "class_g_u_i_client_impl.html", null ]
        ] ]
      ] ],
      [ "ConnectPromptInfoBase", "class_connect_prompt_info_base.html", [
        [ "ConnectPromptInfo", "class_connect_prompt_info.html", null ]
      ] ],
      [ "CWinApp", "class_c_win_app.html", [
        [ "Gui", "class_gui.html", null ]
      ] ],
      [ "FirewallInfo", "class_firewall_info.html", null ],
      [ "PromptEntryBase::GroupAttributes", "class_prompt_entry_base_1_1_group_attributes.html", null ],
      [ "PreferenceBase", "class_preference_base.html", [
        [ "Preference", "class_preference.html", null ]
      ] ],
      [ "PreferenceInfoBase", "class_preference_info_base.html", [
        [ "PreferenceInfo", "class_preference_info.html", null ]
      ] ],
      [ "PromptEntryBase", "class_prompt_entry_base.html", [
        [ "PromptEntry", "class_prompt_entry.html", null ]
      ] ],
      [ "ProtocolInfo", "class_protocol_info.html", null ],
      [ "RouteInfo", "class_route_info.html", null ],
      [ "PromptEntryBase::SingleAttributes", "class_prompt_entry_base_1_1_single_attributes.html", null ],
      [ "VPNStatsBase", "class_v_p_n_stats_base.html", [
        [ "VPNStats", "class_v_p_n_stats.html", null ]
      ] ]
    ] ],
    [ "Class Members", "functions.html", null ],
    [ "File List", "files.html", [
      [ "examples/CLI/CLIClientImpl.cpp", "_c_l_i_client_impl_8cpp.html", null ],
      [ "examples/CLI/CLIClientImpl.h", null, null ],
      [ "examples/GUI/Gui.h", null, null ],
      [ "examples/GUI/GUIClientImpl.cpp", "_g_u_i_client_impl_8cpp.html", null ],
      [ "examples/GUI/GUIClientImpl.h", null, null ],
      [ "examples/GUI/MainDialog.cpp", "_main_dialog_8cpp.html", null ],
      [ "examples/GUI/MainDialog.h", null, null ],
      [ "examples/GUI/PromptDialog.h", null, null ],
      [ "examples/GUI/resource.h", null, null ],
      [ "examples/GUI/stdafx.h", null, null ],
      [ "include/api.h", "api_8h.html", null ],
      [ "include/ClientIfc.h", null, null ],
      [ "include/ClientIfcBase.h", null, null ],
      [ "include/ClientIfcCommon.h", null, null ],
      [ "include/ConnectPromptInfo.h", null, null ],
      [ "include/ConnectPromptInfoBase.h", null, null ],
      [ "include/FirewallInfo.h", null, null ],
      [ "include/GlobalEnums.h", null, null ],
      [ "include/Preference.h", null, null ],
      [ "include/PreferenceBase.h", null, null ],
      [ "include/PreferenceInfo.h", null, null ],
      [ "include/PreferenceInfoBase.h", null, null ],
      [ "include/PromptEntry.h", null, null ],
      [ "include/PromptEntryBase.h", null, null ],
      [ "include/ProtocolInfo.h", null, null ],
      [ "include/RouteInfo.h", null, null ],
      [ "include/VPNStats.h", null, null ],
      [ "include/VPNStatsBase.h", null, null ]
    ] ],
    [ "File Members", "globals.html", null ]
  ] ]
];

function createIndent(o,domNode,node,level)
{
  if (node.parentNode && node.parentNode.parentNode)
  {
    createIndent(o,domNode,node.parentNode,level+1);
  }
  var imgNode = document.createElement("img");
  if (level==0 && node.childrenData)
  {
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() 
    {
      if (node.expanded) 
      {
        $(node.getChildrenUL()).slideUp("fast");
        if (node.isLast)
        {
          node.plus_img.src = node.relpath+"ftv2plastnode.png";
        }
        else
        {
          node.plus_img.src = node.relpath+"ftv2pnode.png";
        }
        node.expanded = false;
      } 
      else 
      {
        expandNode(o, node, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
  }
  else
  {
    domNode.appendChild(imgNode);
  }
  if (level==0)
  {
    if (node.isLast)
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2plastnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2lastnode.png";
        domNode.appendChild(imgNode);
      }
    }
    else
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2pnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2node.png";
        domNode.appendChild(imgNode);
      }
    }
  }
  else
  {
    if (node.isLast)
    {
      imgNode.src = node.relpath+"ftv2blank.png";
    }
    else
    {
      imgNode.src = node.relpath+"ftv2vertline.png";
    }
  }
  imgNode.border = "0";
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  a.appendChild(node.label);
  if (link) 
  {
    a.href = node.relpath+link;
  } 
  else 
  {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
      node.expanded = false;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() 
  {
    if (!node.childrenUL) 
    {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
}

function expandNode(o, node, imm)
{
  if (node.childrenData && !node.expanded) 
  {
    if (!node.childrenVisited) 
    {
      getNode(o, node);
    }
    if (imm)
    {
      $(node.getChildrenUL()).show();
    } 
    else 
    {
      $(node.getChildrenUL()).slideDown("fast",showRoot);
    }
    if (node.isLast)
    {
      node.plus_img.src = node.relpath+"ftv2mlastnode.png";
    }
    else
    {
      node.plus_img.src = node.relpath+"ftv2mnode.png";
    }
    node.expanded = true;
  }
}

function getNode(o, po)
{
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) 
  {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
        i==l);
  }
}

function findNavTreePage(url, data)
{
  var nodes = data;
  var result = null;
  for (var i in nodes) 
  {
    var d = nodes[i];
    if (d[1] == url) 
    {
      return new Array(i);
    }
    else if (d[2] != null) // array of children
    {
      result = findNavTreePage(url, d[2]);
      if (result != null) 
      {
        return (new Array(i).concat(result));
      }
    }
  }
  return null;
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;

  getNode(o, o.node);

  o.breadcrumbs = findNavTreePage(toroot, NAVTREE);
  if (o.breadcrumbs == null)
  {
    o.breadcrumbs = findNavTreePage("index.html",NAVTREE);
  }
  if (o.breadcrumbs != null && o.breadcrumbs.length>0)
  {
    var p = o.node;
    for (var i in o.breadcrumbs) 
    {
      var j = o.breadcrumbs[i];
      p = p.children[j];
      expandNode(o,p,true);
    }
    p.itemDiv.className = p.itemDiv.className + " selected";
    p.itemDiv.id = "selected";
    $(window).load(showRoot);
  }
}

