/*******************************************************************************
*   Copyright (c) 2007, 2022 Cisco Systems Inc.
*   All Rights Reserved. Cisco Highly Confidential.
********************************************************************************
**
**  GlobalEnums.h
**  
**  Contains enumerations used in the API and TLV classes.
**
*********************************************************************************/

#ifndef __GLOBALENUMS_H
#define __GLOBALENUMS_H

/*****    PUT ONLY ENUMS IN THIS FILE AS IT IS ALSO USED BY THE MIDL COMPILER  *****\
\******************** This is also compiled with IDL compiler **********************/

enum ConnectProtocolType
{
    PROTOCOL_TYPE_UNKNOWN = 0,
    PROTOCOL_TYPE_SSL,
    PROTOCOL_TYPE_IPSEC,
};

enum ProtocolVersion 
{
    PROTO_VERSION_UNKNOWN           = 0,
    PROTO_VERSION_TLS10             = 1,
    PROTO_VERSION_SSL30             = 2,
    PROTO_VERSION_DTLS10            = 3,
    PROTO_VERSION_IPSEC             = 4,
    PROTO_VERSION_IPSEC_NAT_T       = 5,
    PROTO_VERSION_TLS11             = 6,
    PROTO_VERSION_TLS12             = 7,
    PROTO_VERSION_DTLS12            = 8,
    PROTO_VERSION_TLS13             = 9,
};

enum ProtocolCipher
{
    PROTO_CIPHER_UNKNOWN            =  0,
    PROTO_CIPHER_RSA_RC4_128_MD5    =  1,
    PROTO_CIPHER_RSA_RC4_128_SHA1   =  2,
    PROTO_CIPHER_RSA_DES_56_SHA1    =  3,
    PROTO_CIPHER_RSA_3DES_168_SHA1  =  4,
    PROTO_CIPHER_RSA_AES_128_SHA1   =  5,
    PROTO_CIPHER_RSA_AES_256_SHA1   =  6,
    PROTO_CIPHER_ENC_NULL_MD5       =  7,
    PROTO_CIPHER_ENC_NULL_SHA1      =  8,
    PROTO_CIPHER_RC4_128            =  9,
    PROTO_CIPHER_RC4_128_MD5        = 10,
    PROTO_CIPHER_RC4_128_SHA1       = 11,
    PROTO_CIPHER_DES_56             = 12,
    PROTO_CIPHER_DES_56_MD5         = 13,
    PROTO_CIPHER_DES_56_SHA1        = 14,
    PROTO_CIPHER_DES_56_SHA256      = 15,
    PROTO_CIPHER_DES_56_SHA384      = 16,
    PROTO_CIPHER_DES_56_SHA512      = 17,
    PROTO_CIPHER_3DES_168           = 18,
    PROTO_CIPHER_3DES_168_MD5       = 19,
    PROTO_CIPHER_3DES_168_SHA1      = 20,
    PROTO_CIPHER_3DES_168_SHA256    = 21,
    PROTO_CIPHER_3DES_168_SHA384    = 22,
    PROTO_CIPHER_3DES_168_SHA512    = 23,
    PROTO_CIPHER_AES_128            = 24,
    PROTO_CIPHER_AES_128_MD5        = 25,
    PROTO_CIPHER_AES_128_SHA1       = 26,
    PROTO_CIPHER_AES_128_SHA256     = 27,
    PROTO_CIPHER_AES_128_SHA384     = 28,
    PROTO_CIPHER_AES_128_SHA512     = 29,
    PROTO_CIPHER_AES_192            = 30,
    PROTO_CIPHER_AES_192_MD5        = 31,
    PROTO_CIPHER_AES_192_SHA1       = 32,
    PROTO_CIPHER_AES_192_SHA256     = 33,
    PROTO_CIPHER_AES_192_SHA384     = 34,
    PROTO_CIPHER_AES_192_SHA512     = 35,
    PROTO_CIPHER_AES_256            = 36,
    PROTO_CIPHER_AES_256_MD5        = 37,
    PROTO_CIPHER_AES_256_SHA1       = 38,
    PROTO_CIPHER_AES_256_SHA256     = 39,
    PROTO_CIPHER_AES_256_SHA384     = 40,
    PROTO_CIPHER_AES_256_SHA512     = 41,
    PROTO_CIPHER_AES_128_GCM        = 42,
    PROTO_CIPHER_AES_192_GCM        = 43,
    PROTO_CIPHER_AES_256_GCM        = 44,
    PROTO_CIPHER_RSA_AES_128_SHA256 = 45,   // TLS 1.2
    PROTO_CIPHER_RSA_AES_256_SHA256 = 46,
    PROTO_CIPHER_DHE_RSA_AES_128_SHA256 = 47,
    PROTO_CIPHER_DHE_RSA_AES_256_SHA256 = 48,
    PROTO_CIPHER_ECDHE_ECDSA_AES256_GCM_SHA384 = 49,    // TLS 1.2 phase 2
    PROTO_CIPHER_ECDHE_RSA_AES256_GCM_SHA384   = 50,
    PROTO_CIPHER_DHE_RSA_AES256_GCM_SHA384     = 51,
    PROTO_CIPHER_AES256_GCM_SHA384             = 52,
    PROTO_CIPHER_ECDHE_ECDSA_AES256_SHA384     = 53,
    PROTO_CIPHER_ECDHE_RSA_AES256_SHA384       = 54,
    PROTO_CIPHER_ECDHE_ECDSA_AES128_GCM_SHA256 = 55,
    PROTO_CIPHER_ECDHE_RSA_AES128_GCM_SHA256   = 56,
    PROTO_CIPHER_DHE_RSA_AES128_GCM_SHA256     = 57,
    PROTO_CIPHER_AES128_GCM_SHA256             = 58,
    PROTO_CIPHER_ECDHE_ECDSA_AES128_SHA256     = 59,
    PROTO_CIPHER_ECDHE_RSA_AES128_SHA256       = 60,
    PROTO_CIPHER_DHE_RSA_AES256_SHA            = 61,
    PROTO_CIPHER_DHE_RSA_AES128_SHA            = 62,
    PROTO_CIPHER_AES_128_GCM_SHA256            = 63,    // TLS 1.3
    PROTO_CIPHER_AES_256_GCM_SHA384            = 64,
    PROTO_CIPHER_CHACHA20_POLY1305_SHA256      = 65,
    PROTO_CIPHER_AES_128_CCM_SHA256            = 66
};

typedef enum
{
    COMPR_NONE = 0,
    COMPR_DEFLATE = 1,
    COMPR_LZS = 2
} COMPR_ALGORITHM;   

/*
** VPN Session States
**  New states must be added to the end of the list.
**  Downloader tests states, so altering existing states requires verification
**  that there won't be backward compability issues with downloader.
*/
//BUGBUG  Suggested by Marc: Rename the STATE enum and its symbolic values.
//BUGBUG  We should probably change the enum name from STATE to VPNSES_STATE and
//BUGBUG  the prefixes on the values from STATE_ to VSS_ (for VPN session state).
//BUGBUG  The API and GUI code have to deal with a number of different states, and the 
//BUGBUG  generically named STATE is not very self documenting.
//BUGBUG  It's a throw back from the very earliest code for SSL VPN.
typedef enum
{
    STATE_CONNECTING,
    STATE_CONNECTED,
    STATE_RECONNECTING,
    STATE_DISCONNECTING,
    STATE_DISCONNECTED,
    STATE_PAUSING,
    STATE_PAUSED,
    STATE_AUTHENTICATING,
    STATE_SSOPOLLING,       // Api is doing the auth-poll.
    STATE_UNDEFINED,
} STATE;

/*
** Tunnel sub-states
**  New sub-states must be added to the end of the list.
**  Sub-states are meant to provide additional details, if necessary, about 
**  any of the VPN connection states.
**  Substates prefixed with "VCSS_MT_" correspond to the management tunnel.
*/
enum VPNCON_SUBSTATE
{
    VCSS_NORMAL                             = 0,
    VCSS_INDEFINITE_DELAY                   = (1 << 0),
    VCSS_SESSION_EXPIRING                   = (1 << 1),
    VCSS_MT_DISCONNECTED_DISABLED           = (1 << 2),
    VCSS_MT_DISCONNECTED_TRUSTED_NW         = (1 << 3),
    VCSS_MT_DISCONNECTED_USER_TUNNEL_ACTIVE = (1 << 4),
    VCSS_MT_DISCONNECTED_LAUNCH_FAILED      = (1 << 5),
    VCSS_MT_DISCONNECTED_CONNECT_FAILED     = (1 << 6),
    VCSS_MT_DISCONNECTED_BAD_VPN_CONFIG     = (1 << 7),
    VCSS_MT_DISCONNECTED_SW_UP_PENDING      = (1 << 8),
    VCSS_MTU_ADJUSTMENT_PENDING             = (1 << 9)
};

typedef enum
{
    NCS_RESTRICTED = 0, //a client configuration has been applied to the endpoints 
                        //operating system configuration
    NCS_PARTIAL_RESTRICTED_CAPTIVE_PORTAL, //a client configuration has been applied to the 
                                           //endpoints operating system configuration to allow
                                           //captive portal remediation
    NCS_UNRESTRICTED    //the endpoints operating system configuration is not currently altered by the client
} NETCTRL_STATE;


// Note that while these values are defined like a bitmap, the network environment state
// is not used as a bitmap. No two values are ever combined.  They are used like linear
// values. The bitmap arrangement of values is to enable testing for many possible values
// all at once in a single compare without having to do a series of compares against
// different linear values.
//
typedef enum
{
    NES_NO_NETWORK_INTERFACE        = (1 << 0),
    NES_NO_PUBLIC_INTERFACE         = (1 << 1),
    NES_NO_DNS_CONNECTIVITY         = (1 << 2),
    NES_CAPTIVE_PORTAL_DETECTED     = (1 << 3),
    NES_AUTH_PROXY_DETECTED         = (1 << 4),
    NES_NETWORK_ACCESSIBLE          = (1 << 5),
    NES_SECURE_GATEWAY_ACCESSIBLE   = (1 << 6)
} NETENV_STATE;


// Trusted Network Detection types.
typedef enum
{
    NT_TRUSTED,
    NT_UNTRUSTED,
    NT_UNDEFINED
} NETWORK_TYPE;

// Firewall enums
typedef enum
{   FW_PERMISSION_UNKNOWN,
    FW_PERMISSION_PERMIT,
    FW_PERMISSION_DENY
} FW_Permission;

typedef enum
{   FW_PROTOCOL_UNKNOWN,
    FW_PROTOCOL_TCP,
    FW_PROTOCOL_UDP,
    FW_PROTOCOL_ICMP,
    FW_PROTOCOL_ANY
} FW_Protocol;

typedef enum
{
    FW_INTERFACE_UNKNOWN,
    FW_INTERFACE_PUBLIC,
    FW_INTERFACE_PRIVATE
} FW_Interface;

typedef enum
{
    FW_RULE_DIRECTION_IN,
    FW_RULE_DIRECTION_OUT,
    FW_RULE_DIRECTION_BOTH
} FW_Rule_Direction;

typedef enum
{
    MUS_STATUS_UNKNOWN = 0,
    MUS_STATUS_ENABLED,
    MUS_STATUS_DISABLED,
    MUS_STATUS_UNCONFIRMED
} MUS_STATUS;

// These can be used to get/set an automatic preference value using the
// generic UserPreferences.getAutomaticPreferenceValue() and
// setAutomaticPreferenceValue() methods, rather than using the individual
// getters/setters.
typedef enum 
{   
    HeadendSelectionCacheId = 0,
    DefaultUserId,
    DefaultSecondUserId,
    DefaultHostId,
    DefaultGroupId,
    ProxyHostId,
    ProxyPortId,
    SDITokenTypeId,
    NoSDITokenId,
    ClientCertThumbprintId,
    ServerCertThumbprintId,
    UnknownAutomaticPreference
}  AutoPreferenceId ;

// Used to determine if CPublicProxies, CPrivateProxies or no proxies should be used.
typedef enum
{
    TRANSPORT_PROXY_NONE,
    TRANSPORT_PROXY_PUBLIC,
    TRANSPORT_PROXY_CURRENT
} TRANSPORT_PROXY_TYPE;

// user authentication methods
// these are shared between Agent and API
//
// Note that IKE PSK is supported for reconnects only.  The API can never
// initiate an IPsec connection using IKE PSK authentication.
typedef enum
{
    USER_AUTH_UNKNOWN = 0,
    USER_AUTH_SSL_MACHINE_STORE_CERT,
    USER_AUTH_IKE_PSK,
    USER_AUTH_IKE_RSA,
    USER_AUTH_IKE_ECDSA,
    USER_AUTH_IKE_EAP_MD5,
    USER_AUTH_IKE_EAP_MSCHAPv2,
    USER_AUTH_IKE_EAP_GTC,
    USER_AUTH_IKE_EAP_ANYCONNECT,  // Default
} USER_AUTH_METHOD;

typedef enum
{
    CFR_NONE = 0,
    CFR_HOST_UNREACHABLE,
} CONNECT_FAILURE_REASON;

typedef enum 
{
    DYN_SPLIT_TUN_EXC,
    DYN_SPLIT_TUN_INC
} DYN_SPLIT_TUN_TYPE;

typedef enum
{
    VPN_TUNNEL_SCOPE_USER,
    VPN_TUNNEL_SCOPE_MACHINE,
    VPN_TUNNEL_SCOPE_UNDEFINED
} VPN_TUNNEL_SCOPE;

#define IS_USER_TUNNEL(x)    (VPN_TUNNEL_SCOPE_USER == x)
#define IS_MGMT_TUNNEL(x)    (VPN_TUNNEL_SCOPE_MACHINE == x)

#endif // __GLOBALENUMS_H
